// MQTT Configuration for Grid Frequency Monitor Dashboard
// Update these settings to match your MQTT broker

const MQTT_CONFIG = {
    // MQTT Broker Settings
    broker: 'robertrileyruark.com',
    port: 9001,  // WebSocket port (usually 9001 for MQTT over WebSocket)
    protocol: 'ws',  // or 'wss' for secure WebSocket
    
    // Topic Settings
    topic: 'grid/frequency_west',
    
    // Connection Settings
    clientId: 'web_dashboard_' + Math.random().toString(16).substr(2, 8),
    clean: true,
    reconnectPeriod: 5000,  // 5 seconds
    connectTimeout: 30000,  // 30 seconds
    
    // Alternative broker settings (uncomment to use)
    // broker: 'test.mosquitto.org',
    // port: 8080,
    // topic: 'test/grid/frequency',
};

// Export for use in HTML file
if (typeof module !== 'undefined' && module.exports) {
    module.exports = MQTT_CONFIG;
}
