/*
 * Configuration file for ESP32 Grid Frequency Monitor
 * Modify these settings to match your environment
 */

#ifndef CONFIG_H
#define CONFIG_H

// WiFi Configuration
#define WIFI_SSID "starlink"
#define WIFI_PASSWORD "redmondwa"

// MQTT Configuration
#define MQTT_SERVER "robertrileyruark.com"
#define MQTT_PORT 1883
#define MQTT_TOPIC "grid/frequency"
#define MQTT_CLIENT_ID "ESP32FrequencyMonitor"

// Alternative MQTT broker for testing (uncomment to use)
// #define MQTT_SERVER "test.mosquitto.org"
// #define MQTT_TOPIC "test/grid/frequency"

// Pin Configuration
#define AC_FREQ_PIN 2
#define GPS_PPS_PIN 4
#define GPS_UART_PIN 16
#define STEPPER_PIN1 23
#define STEPPER_PIN2 17
#define STEPPER_PIN3 18
#define STEPPER_PIN4 19
#define STATUS_LED 21

// Frequency Measurement Configuration
#define F_CLK 80000000UL        // ESP32 CPU frequency
#define ALPHA 0.1f              // Low-pass filter coefficient for AC frequency
#define ALPHA_PPS 0.01f        // Low-pass filter coefficient for PPS frequency
#define SAMPLE_COUNT 60         // Number of samples for averaging
#define MIN_PERIOD 16400        // Minimum valid period (microseconds) - 61Hz
#define MAX_PERIOD 17000        // Maximum valid period (microseconds) - 59Hz
#define MAX_PERIOD_PPS 1010000  // Maximum valid period (microseconds) - 59Hz

// Stepper Motor Configuration
#define STEP_DELAY 10           // Step delay in milliseconds
#define ZERO_STEPS_DOWN 700     // Steps to move down during zeroing
#define ZERO_STEPS_UP 625       // Steps to move up during zeroing
#define POSITION_SCALE 2.560    // Scale factor for position calculation

// Web Server Configuration
#define WEB_SERVER_PORT 80
#define REFRESH_RATE 1000       // Web page refresh rate in milliseconds

// MQTT Publishing Configuration
#define PUBLISH_INTERVAL 1000   // Publish interval in milliseconds
#define MAX_MQTT_RETRY 5        // Maximum MQTT reconnection attempts

// Debug Configuration
#define SERIAL_BAUD 115200
#define DEBUG_ENABLED true      // Enable debug output

// Frequency Limits (USA Grid)
#define MIN_FREQUENCY 59.0      // Minimum expected frequency (Hz)
#define MAX_FREQUENCY 61.0      // Maximum expected frequency (Hz)
#define NOMINAL_FREQUENCY 60.0  // Nominal grid frequency (Hz) - USA standard

// Calibration
#define PPS_TIMEOUT_MS 2000     // PPS timeout in milliseconds
#define CYCLE_RESET_THRESHOLD 100 // Cycle count threshold for reset

#endif // CONFIG_H
