# ESP32 Grid Frequency Monitor - Arduino Project

A high-precision 60Hz USA grid frequency monitoring system ported from STM32 to ESP32 with Arduino framework.

## Quick Start

1. **Open in Arduino IDE**: Open the `esp32_grid_frequency_monitor.ino` file
2. **Install Libraries**: Install PubSubClient and ArduinoJson via Library Manager
3. **Select Board**: Choose ESP32 Dev Module in Tools → Board
4. **Upload**: Click Upload button

## WiFi Configuration

The project is pre-configured for:
- **SSID**: starlink
- **Password**: redmondwa

To change WiFi settings, edit `config.h`:
```cpp
#define WIFI_SSID "your_wifi_name"
#define WIFI_PASSWORD "your_wifi_password"
```

## Pin Connections

| Function | ESP32 Pin | Description |
|----------|-----------|-------------|
| AC Frequency Input | GPIO 2 | Square wave from AC detector |
| GPS 1PPS Input | GPIO 4 | 1 Pulse Per Second from GPS |
| GPS UART RX | GPIO 16 | NMEA data input |
| Stepper Motor A+ | GPIO 23 | Motor control |
| Stepper Motor A- | GPIO 17 | Motor control |
| Stepper Motor B+ | GPIO 18 | Motor control |
| Stepper Motor B- | GPIO 19 | Motor control |
| Status LED | GPIO 21 | Status indicator |

## Features

- **60Hz USA Grid Frequency**: Optimized for US electrical grid
- **GPS 1PPS Calibration**: Improves accuracy beyond internal oscillator
- **Stepper Motor Display**: Physical gauge showing frequency deviation
- **MQTT Publishing**: Sends data to robertrileyruark.com
- **Web Dashboard**: Real-time monitoring via web browser
- **WiFi Connectivity**: Remote access and configuration

## Web Interface

After uploading, access the dashboard at:
- **URL**: `http://[ESP32_IP_ADDRESS]/`
- **API**: `http://[ESP32_IP_ADDRESS]/api`
- **Config**: `http://[ESP32_IP_ADDRESS]/config`

## Test Mode

Use `test_basic_functionality.ino` to test without actual frequency inputs:
- Tests WiFi connection
- Tests MQTT connection
- Tests stepper motor movement
- Simulates frequency measurement

## MQTT Data Format

Published to topic `grid/frequency`:
```json
{
  "frequency_mhz": 60000.0,
  "frequency_hz": 60.0,
  "deviation_mhz": 0.0,
  "deviation_hz": 0.0,
  "pps_detected": true,
  "pps_frequency": 1.0,
  "position": 0,
  "cycle_count": 60,
  "timestamp": 12345678,
  "uptime": 12345
}
```

## Troubleshooting

1. **WiFi Issues**: Check SSID/password in config.h
2. **Compilation Errors**: Install required libraries
3. **Upload Issues**: Check COM port and board selection
4. **No Web Interface**: Check serial monitor for IP address

## Hardware Requirements

- ESP32 Dev Board
- GPS module with 1PPS output
- AC frequency detector circuit
- 4-wire bipolar stepper motor
- Status LED
- Power supply (3.3V or 5V)

## Files in This Project

- `esp32_grid_frequency_monitor.ino` - Main production code
- `test_basic_functionality.ino` - Test code
- `config.h` - Configuration settings
- `libraries.txt` - Required libraries list
- `README.md` - This file

## Support

For technical support, check the serial monitor output at 115200 baud for debug information.
