# MQTT Dashboard for Grid Frequency Monitor

This is a standalone web dashboard that displays real-time grid frequency data by subscribing to MQTT messages from the ESP32 Grid Frequency Monitor.

## Features

- **Real-time Updates**: Automatically receives data via MQTT
- **Identical UI**: Matches the ESP32's web interface exactly
- **GPS Integration**: Shows GPS time, date, and PPS status
- **Visual Gauge**: Color-coded frequency gauge (green at 60Hz, red at extremes)
- **Responsive Design**: Works on desktop and mobile devices
- **Connection Status**: Shows MQTT connection status
- **Auto-reconnect**: Automatically reconnects if connection is lost

## Files

- `mqtt_dashboard.html` - Main dashboard page
- `mqtt_config.js` - MQTT broker configuration
- `MQTT_DASHBOARD_README.md` - This documentation

## Setup Instructions

### 1. Apache Web Server Setup

1. Copy `mqtt_dashboard.html` to your Apache web root directory:
   ```bash
   sudo cp mqtt_dashboard.html /var/www/html/
   ```

2. Ensure Apache is running:
   ```bash
   sudo systemctl start apache2
   sudo systemctl enable apache2
   ```

3. Access the dashboard at: `http://your-server-ip/mqtt_dashboard.html`

### 2. MQTT Broker Configuration

The dashboard connects to the MQTT broker specified in `mqtt_dashboard.html`. By default, it's configured for:
- **Broker**: `robertrileyruark.com`
- **Port**: `9001` (WebSocket)
- **Topic**: `grid/frequency`

#### To change MQTT settings:

1. Edit `mqtt_dashboard.html`
2. Find the MQTT configuration section:
   ```javascript
   const MQTT_BROKER = 'ws://robertrileyruark.com:9001';
   const MQTT_TOPIC = 'grid/frequency';
   ```
3. Update with your MQTT broker details

#### Alternative MQTT Brokers:

For testing, you can use a public MQTT broker:
```javascript
const MQTT_BROKER = 'ws://test.mosquitto.org:8080';
const MQTT_TOPIC = 'test/grid/frequency';
```

### 3. MQTT Broker Requirements

Your MQTT broker must support:
- **WebSocket connections** (port 9001 or 8080)
- **No authentication** (or update the code to include credentials)
- **CORS headers** (if serving from a different domain)

### 4. ESP32 Configuration

Ensure your ESP32 is publishing to the correct MQTT topic. The default topic is `grid/frequency` and should contain JSON data with these fields:

```json
{
  "device_name": "Grid Frequency Monitor",
  "frequency_hz": 60.000,
  "pps_detected": true,
  "gps_time": "08:27:57",
  "gps_date": "27/09/2025",
  "gps_time_valid": true,
  "raw_frequency": 60.000,
  "pps_frequency": 1.000000,
  "osc_error_ppm": 0.00
}
```

## Troubleshooting

### Connection Issues

1. **Check MQTT broker accessibility**:
   ```bash
   telnet robertrileyruark.com 9001
   ```

2. **Verify WebSocket support**: Ensure your MQTT broker supports WebSocket connections

3. **Check browser console**: Open browser developer tools to see connection errors

### Data Not Updating

1. **Verify MQTT topic**: Ensure ESP32 is publishing to the correct topic
2. **Check JSON format**: Ensure the MQTT payload is valid JSON
3. **Monitor MQTT traffic**: Use an MQTT client to verify data is being published

### Display Issues

1. **Check browser compatibility**: Requires modern browser with WebSocket support
2. **Verify CSS loading**: Ensure all styles are loading correctly
3. **Check JavaScript errors**: Look for errors in browser console

## Security Considerations

- **HTTPS/WSS**: For production use, consider using secure WebSocket (WSS) connections
- **Authentication**: Add MQTT username/password if your broker requires it
- **CORS**: Configure CORS headers if serving from different domains
- **Firewall**: Ensure MQTT WebSocket port is accessible

## Customization

### Styling
Edit the CSS in `mqtt_dashboard.html` to match your preferences:
- Colors, fonts, layout
- Gauge appearance and colors
- Responsive breakpoints

### Data Fields
Add or remove data fields by:
1. Adding HTML elements in the info boxes
2. Updating the `updateDisplay()` function
3. Ensuring the ESP32 publishes the required data

### Update Frequency
The dashboard updates in real-time as MQTT messages arrive. The ESP32 publishes every 5 seconds by default.

## Support

For issues with the MQTT dashboard:
1. Check browser console for JavaScript errors
2. Verify MQTT broker connectivity
3. Ensure ESP32 is publishing data correctly
4. Check network connectivity between web server and MQTT broker
