# Installation Guide - ESP32 Grid Frequency Monitor

## Prerequisites

1. **Arduino IDE** (version 1.8.19 or later)
2. **ESP32 Arduino Core** (version 2.0.0 or later)
3. **Required Libraries** (see libraries.txt)

## Step 1: Install ESP32 Arduino Core

1. Open Arduino IDE
2. Go to **File → Preferences**
3. Add this URL to **Additional Board Manager URLs**:
   ```
   https://raw.githubusercontent.com/espressif/arduino-esp32/gh-pages/package_esp32_index.json
   ```
4. Go to **Tools → Board → Boards Manager**
5. Search for "ESP32" and install **esp32 by Espressif Systems**

## Step 2: Install Required Libraries

1. Go to **Tools → Manage Libraries**
2. Install these libraries:
   - **PubSubClient** by Nick O'Leary
   - **ArduinoJson** by Benoit Blanchon

## Step 3: Open the Project

1. Open Arduino IDE
2. Go to **File → Open**
3. Navigate to this directory
4. Open `esp32_grid_frequency_monitor.ino`

## Step 4: Configure Board Settings

1. Go to **Tools → Board → ESP32 Arduino → ESP32 Dev Module**
2. Select your **COM Port** (Tools → Port)
3. Set **Upload Speed** to 115200 (Tools → Upload Speed)

## Step 5: Upload the Code

1. Click the **Upload** button (arrow icon)
2. Wait for compilation and upload to complete
3. Open **Serial Monitor** (Tools → Serial Monitor)
4. Set baud rate to **115200**

## Step 6: Test the System

1. **Check Serial Output**: Look for WiFi connection status
2. **Note IP Address**: Copy the IP address from serial output
3. **Open Web Browser**: Navigate to `http://[IP_ADDRESS]/`
4. **Test Features**: Use the web interface to verify functionality

## WiFi Configuration

The project is pre-configured for:
- **SSID**: starlink
- **Password**: redmondwa

To change these settings, edit `config.h` before uploading.

## Test Mode

Before connecting real hardware, test with `test_basic_functionality.ino`:
1. Open `test_basic_functionality.ino` instead of main file
2. Upload and test basic functionality
3. Verify WiFi, MQTT, and stepper motor operation

## Troubleshooting

### Common Issues

1. **"Board not found"**: Install ESP32 Arduino Core
2. **"Library not found"**: Install required libraries
3. **"Compilation error"**: Check library versions
4. **"Upload failed"**: Check COM port and board selection
5. **"WiFi failed"**: Check SSID/password in config.h

### Debug Information

Enable debug output by setting in `config.h`:
```cpp
#define DEBUG_ENABLED true
```

### Serial Monitor Output

Look for these messages:
- `WiFi connected`
- `IP address: [IP]`
- `Web server started`
- `MQTT connected`

## Next Steps

1. **Connect Hardware**: Follow pinout guide
2. **Test Frequency Input**: Connect AC frequency detector
3. **Test GPS PPS**: Connect GPS module
4. **Calibrate Stepper**: Run zeroing sequence
5. **Monitor Data**: Use web interface and MQTT

## Support

- Check serial monitor for error messages
- Verify all connections match pinout guide
- Test individual components before full system
- Use test mode to isolate issues
